<?php
include("../Tollsk/Connectk.php");

// Sanitize and validate the input
$useremail = trim($_GET['useremail']);
if (filter_var($useremail, FILTER_VALIDATE_EMAIL) === false) {
    die("Invalid email address provided");
}

// Prepare the SQL statement to prevent SQL injection
$sql = "SELECT * FROM recharge_history WHERE useremail = ? ORDER BY id DESC LIMIT 100";
$stmt = mysqli_prepare($con, $sql);
if (!$stmt) {
    die('Query Preparation Failed: ' . mysqli_error($con));
}

// Bind the user email to the statement
mysqli_stmt_bind_param($stmt, 's', $useremail);

// Execute the query
mysqli_stmt_execute($stmt);

// Get the result set from the prepared statement
$result = mysqli_stmt_get_result($stmt);

// Initialize the data array
$data = array();

// Fetch data and populate the array
while ($item = mysqli_fetch_assoc($result)) {
    $userInfo = array(
        'status' => $item['status'],
        'mobile' => $item['mobile'],
        'amount' => $item['amount'],
        'rechargeby' => $item['operator_k'],
        'userID' => $item['userID'],
        'id' => $item['id'],
        'date' => $item['date'],
        'trnsid' => $item['trnsid'],
        'offer' => $item['package_k'],
        'cmt' => $item['comment']
    );
    
    $data[] = $userInfo;
}

// Encode the data array to JSON and output it
echo json_encode($data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);

// Close the statement and connection
mysqli_stmt_close($stmt);
mysqli_close($con);
?>