<?php
include("Connectk.php");

$limit = 1000;


$sql = "SELECT number, amount, transaction_id, balance, timestamp FROM recharge ORDER BY id DESC LIMIT ?";


$stmt = mysqli_prepare($con, $sql);
if (!$stmt) {
  
    die('Query Preparation Failed: ' . mysqli_error($con));
}


mysqli_stmt_bind_param($stmt, 'i', $limit);

mysqli_stmt_execute($stmt);


$result = mysqli_stmt_get_result($stmt);


if (!$result) {

    die('Query Execution Failed: ' . mysqli_error($con));
}


$data = array();


while ($item = mysqli_fetch_assoc($result)) {
    
    $userInfo = array(
        'id' => $item['id'],
        'number' => $item['number'],
        'amount' => $item['amount'],
        'transaction_id' => $item['transaction_id'],
        'balance' => $item['balance'],
        'timestamp' => $item['timestamp']
    );
    
    
    $data[] = $userInfo;
}


echo json_encode($data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);


mysqli_stmt_close($stmt);
mysqli_close($con);
?>

