<?php
include("../../Tollsk/Connectk.php");

// Connection check
if ($con->connect_error) {
    die("Connection failed: " . $con->connect_error);
}

// Input Validation (Basic)
if (!isset($_GET['number'], $_GET['amount'], $_GET['transactionId'], $_GET['balance'])) {
    echo "Error: Missing required fields.";
    exit;
}

$number = $_GET['number'];
$amount = $_GET['amount'];
$transactionId = $_GET['transactionId'];
$balance = $_GET['balance'];

// Prevent SQL injection by using prepared statements
$stmt = $con->prepare("INSERT INTO recharge (number, amount, transaction_id, balance) VALUES (?, ?, ?, ?)");
$stmt->bind_param("ssss", $number, $amount, $transactionId, $balance); // "ssss" indicates the type of the variables (all strings)

if ($stmt->execute()) {
    echo "Record saved successfully";
} else {
    echo "Error: " . $stmt->error;
}

$stmt->close();
$con->close();
?>
