<?php
include("../Tollsk/Connectk.php");

// Retrieve and sanitize inputs
$tnxid = mysqli_real_escape_string($con, $_GET['tnxid']);
$sms_body = mysqli_real_escape_string($con, $_GET['sms_body']);
$tnx_op = mysqli_real_escape_string($con, $_GET['tnx_op']);
$status = mysqli_real_escape_string($con, $_GET['status']);
$amount = mysqli_real_escape_string($con, $_GET['amount']);

// Check if tnxid already exists
$check_sql = "SELECT COUNT(*) FROM add_money WHERE tnxid = ?";
$stmt = mysqli_prepare($con, $check_sql);
mysqli_stmt_bind_param($stmt, "s", $tnxid);
mysqli_stmt_execute($stmt);
mysqli_stmt_bind_result($stmt, $count);
mysqli_stmt_fetch($stmt);
mysqli_stmt_close($stmt);

if ($count > 0) {
    // tnxid already exists
    echo "Transaction ID already exists.";
} else {
    // Prepare and execute SQL insert query
    $insert_sql = "INSERT INTO add_money (tnxid, sms_body, tnx_op, status, amount) VALUES (?, ?, ?, ?, ?)";
    $stmt = mysqli_prepare($con, $insert_sql);
    mysqli_stmt_bind_param($stmt, "sssss", $tnxid, $sms_body, $tnx_op, $status, $amount);
    $result = mysqli_stmt_execute($stmt);
    mysqli_stmt_close($stmt);

    if ($result) {
        echo "Pending TnxID added successfully";
    } else {
        echo "Something went wrong! Please try again.";
    }
}

// Close connection
mysqli_close($con);
?>
