<?php
include("../Tollsk/Connectk.php");

// Define the limit for the number of rows to fetch
$limit = 1000;

// SQL query with parameterized order by to prevent SQL injection.
$sql = "SELECT * FROM recharge_history ORDER BY id DESC LIMIT ?";

// Prepare the query
$stmt = mysqli_prepare($con, $sql);
if (!$stmt) {
    // Handle query preparation error
    die('Query Preparation Failed: ' . mysqli_error($con));
}

// Bind the limit parameter to the query
mysqli_stmt_bind_param($stmt, 'i', $limit);

// Execute the query
mysqli_stmt_execute($stmt);

// Get the result set from the prepared statement
$result = mysqli_stmt_get_result($stmt);

// Check if the result is valid
if (!$result) {
    // Handle query execution error
    die('Query Execution Failed: ' . mysqli_error($con));
}

// Initialize the data array
$data = array();

// Fetch data and populate the array
while ($item = mysqli_fetch_assoc($result)) {
    // Populate userInfo array with data from the current item
    $userInfo = array(
        'status' => $item['status'],
        'mobile' => $item['mobile'],
        'amount' => $item['amount'],
        'offer' => $item['package_k'],
        'id' => $item['id'],
        'date' => $item['date'],
        'trnsid' => $item['trnsid'],
        'rechargeby' => $item['operator_k'],
        'useremail' => $item['useremail'],
        'userID' => $item['userID'],
        'token' => $item['token']
    );
    
    // Add userInfo to the data array
    $data[] = $userInfo;
}

// Encode the data array to JSON and output it with JSON_UNESCAPED_UNICODE to ensure proper encoding
echo json_encode($data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);

// Close the statement and connection
mysqli_stmt_close($stmt);
mysqli_close($con);
?>
